function [ddelta_dy,ddelta_dy_hat_bot,ddelta_dy_hat_top,...
    delta,dy,flag_first_call,flag_loc_seismic,flag_merged,flag_merged_unc,...
    p_inc,xi,y_delta,y_tilde_unc] = ...
    fault_slip_delta_cheb_uncoupled(a,alpha,A,b,cheb_terms,delta,delta_c,D_center,...
    eps_reg,eta_reg,flag_echo,flag_first_call,flag_fric,flag_merged,flag_merged_unc,...
    flag_reg,g,G,kappa,K_eff,mu_dyn,mu_st,nu,options,p_0_center,p_inc,phi,rho_f,rho_s,...
    sigma_v_0,small_y_delta,theta,T,U,y_delta,y_plot_max_delta_1,y_plot_min_delta_1,...
    y_tilde_0,z_j)

%
% Auxiliary function file for fault_slip_delta_cheb. Computes y_minus and y_plus for each slip
% patch such that conditions 1 and 2 are fulfilled assuming there is no coupling between the
% patches. 
%

% A) Compute y_minus and y_plus :
% Initialize parameters:
ddelta_dy = 0;
ddelta_dy_bot = 0;
ddelta_dy_hat_bot = 0;
ddelta_dy_hat_top = 0;
ddelta_dy_top = 0;
dy = 0;        
dy_bot = 0;        
dy_top = 0;        
flag_coupled = 0;
flag_loc_seismic = 0; % indicates slip patch where seismicity occurs: 1 = bottom; 2 = top
flag_just_merged = 0; % auxiliary variable in A1) and A2)
N = cheb_terms;
xi = 0;        
y_tilde_unc = zeros(1,4); % slip patch boundaries; intialization
n_0 = [0,0,1./(2*(3:N))];
N_0 = diag(n_0);
n_2 = [0,0,1./(2*(1:N-2))]; % n_tilde
N_2 = diag(n_2); % N_tilde
U_1 = [zeros(N,1),U(:,1:N-1)];
U_2 = [zeros(N,2),U(:,1:N-2)]; % U_tilde

if flag_merged_unc == 0
    % A1) Compute y_minus and y_plus for bottom slip patch (uncoupled):
    y_bound_0 = [y_tilde_0(1) y_tilde_0(2)]; % starting values for bottom slip patch
    [y_bound,~,exitflag] = fsolve(@(y_bound) fault_slip_resid_bound_cheb(a,alpha,b,...
        cheb_terms,0,delta,delta_c,D_center,eps_reg,eta_reg,flag_coupled,...
        flag_fric,flag_merged,flag_reg,g,G,kappa,K_eff,mu_dyn,mu_st,nu,p_0_center,...
        p_inc,phi,rho_f,rho_s,sigma_v_0,theta,T,y_bound,0,y_delta),y_bound_0,options);       
    if 0 < exitflag % solution found
        y_tilde_unc(1) = y_bound(1);
        y_tilde_unc(2) = y_bound(2);
    else
        flag_merged_unc = 1; % no solution found; probably slip patches have merged
        flag_just_merged = 1; % auxiliary variable to ensure A2) is executed 
        y_tilde_unc(1) = y_tilde_0(1);
        y_tilde_unc(2) = (y_tilde_0(2)+y_tilde_0(3))/2; % assumes that starting value y_tilde_0
        %  has been defined as result from previous pressure step
        y_tilde_unc(3) = y_tilde_unc(2);
        y_tilde_unc(4) = y_tilde_0(4);
    end
end

if flag_merged_unc == 0 || flag_just_merged == 1
    if flag_just_merged == 1
        flag_merged_unc = 0; % temporarily set flag_merged_unc = 0 while A2) is executed 
    end
    % A2) Compute y_minus and y_plus for top slip patch (uncoupled):
    y_bound_0 = [y_tilde_0(3) y_tilde_0(4)]; % starting values for top slip patch
    [y_bound,~,exitflag] = fsolve(@(y_bound) fault_slip_resid_bound_cheb(a,alpha,b,...
        cheb_terms,0,delta,delta_c,D_center,eps_reg,eta_reg,flag_coupled,...
        flag_fric,flag_merged,flag_reg,g,G,kappa,K_eff,mu_dyn,mu_st,nu,p_0_center,...
        p_inc,phi,rho_f,rho_s,sigma_v_0,theta,T,y_bound,0,y_delta),y_bound_0,options);
    if 0 < exitflag % solution found
        y_tilde_unc(3) = y_bound(1);
        y_tilde_unc(4) = y_bound(2);
    else
        flag_merged_unc = 1; % no solution found; probably slip patches have merged
        y_tilde_unc(1) = y_tilde_0(1);
        y_tilde_unc(2) = (y_tilde_0(2)+y_tilde_0(3))/2; % assumes that starting value ...
        % y_tilde_0 has been defined as result from previous pressure step
        y_tilde_unc(3) = y_tilde_unc(2);
        y_tilde_unc(4) = y_tilde_0(4);
    end
    if y_tilde_unc(2) > y_tilde_unc(3)
        flag_merged_unc = 1; % slip patches have merged
        if flag_echo > 0
            fprintf('\rSlip patches have merged                p_inc = %7.4f MPa\r\r',...
                p_inc/1e6);
        end
        y_tilde_unc(2) = (y_tilde_unc(2)+y_tilde_unc(3))/2;
        y_tilde_unc(3) = y_tilde_unc(2);
    end
    if flag_just_merged == 1
        flag_merged_unc = 1; % reset flag_merged_unc
    end   
end

if flag_merged == 0  
    % A3) Compute slip gradient for bottom slip patch (uncoupled):
    % A3a) Use regular Chebyshev points z_j: 
    c_n_bot = fault_slip_cheb_coeff_sigma(a,alpha,b,delta,delta_c,D_center,eps_reg,eta_reg,...
        flag_fric,flag_reg,g,kappa,K_eff,mu_dyn,mu_st,0,nu,cheb_terms,T,p_0_center,...
        p_inc,phi,rho_f,rho_s,sigma_v_0,theta,y_delta,y_tilde_unc(1),y_tilde_unc(2));
    ddelta_dy_bot = ( -1/(pi*A) * sqrt(1-z_j'.^2) .* U_1 * c_n_bot )';
    Delta_y = y_tilde_unc(2)-y_tilde_unc(1);
    y_barbar = (y_tilde_unc(1)+y_tilde_unc(2))/2;
    y_bot = y_barbar + z_j * Delta_y/2; % rescaled Chebyshev points
    dy_bot = diff(y_bot);
    % A3b) Use special Chebyshev points z_j_hat for computation of cross terms:
    Delta_y_hat = y_tilde_unc(4)-y_tilde_unc(1);
    y_barbar_hat = (y_tilde_unc(1)+y_tilde_unc(4))/2;
    y_hat = y_barbar_hat + z_j * Delta_y_hat/2; % rescaled Chebyshev points
    y_bot_hat = nonzeros( y_hat .* (y_tilde_unc(1) < y_hat) ...
        .* (y_hat < y_tilde_unc(2)) )';
    z_j_bot_hat = 2 * ((y_bot_hat-y_barbar)/Delta_y);
    M = length(z_j_bot_hat);
    [U_bot_hat,~] = fault_slip_cheb_matrix_U(N,M,6,z_j_bot_hat);
    U_1_bot_hat = [zeros(M,1),U_bot_hat(:,1:N-1)];
    ddelta_dy_hat_bot = ( -1/(pi*A) * sqrt(1-z_j_bot_hat'.^2) .* U_1_bot_hat * c_n_bot )';  

    % A4) Compute slip for bottom slip patch (uncoupled):
    delta_bot = ( -(Delta_y/2) * sqrt(1-z_j'.^2) / (pi*A) .* ( U*N_0 - U_2*N_2) * c_n_bot )';

    % A5) Compute slip gradient for top slip patch (uncoupled):   
    % A5a) Use regular Chebyshev points z_j: 
    c_n_top = fault_slip_cheb_coeff_sigma(a,alpha,b,delta,delta_c,D_center,eps_reg,eta_reg,...
        flag_fric,flag_reg,g,kappa,K_eff,mu_dyn,mu_st,0,nu,cheb_terms,T,p_0_center,...
        p_inc,phi,rho_f,rho_s,sigma_v_0,theta,y_delta,y_tilde_unc(3),y_tilde_unc(4));
    ddelta_dy_top = ( -1/(pi*A) * sqrt(1-z_j'.^2) .* U_1 * c_n_top )';
    Delta_y =   y_tilde_unc(4)-y_tilde_unc(3);
    y_barbar = (y_tilde_unc(3)+y_tilde_unc(4))/2;
    y_top = y_barbar + z_j * Delta_y/2; % rescaled Chebyshev points
    dy_top = diff(y_top);
    % A5b) Use special Chebyshev points z_j_hat for computation of cross terms: 
    Delta_y_hat = y_tilde_unc(4)-y_tilde_unc(1);
    y_barbar_hat = (y_tilde_unc(1)+y_tilde_unc(4))/2;
    y_hat = y_barbar_hat + z_j * Delta_y_hat/2; % rescaled Chebyshev points
    y_top_hat = nonzeros( y_hat .* (y_tilde_unc(3) < y_hat) ...
        .* (y_hat < y_tilde_unc(4)) )';
    z_j_top_hat = 2 * ((y_top_hat-y_barbar)/Delta_y);
    M = length(z_j_top_hat);
    [U_top_hat,~] = fault_slip_cheb_matrix_U(N,M,6,z_j_top_hat);
    U_1_top_hat = [zeros(M,1),U_top_hat(:,1:N-1)];
    ddelta_dy_hat_top = ( -1/(pi*A) * sqrt(1-z_j_top_hat'.^2) .* U_1_top_hat * c_n_top )';  

    % A6) Compute slip for top slip patch (uncoupled):
    delta_top = ( -(Delta_y/2) * sqrt(1-z_j'.^2) / (pi*A) .* ( U*N_0 - U_2*N_2) * c_n_top )';

    % A7) Combine data for bottom and top patches (uncoupled):
    ddelta_dy = [0 ddelta_dy_bot ddelta_dy_top 0];
    dy = [dy_bot dy_top];
    delta = [0 delta_bot delta_top 0];
    xi = [y_bot y_top];
    y_delta_min = min(y_plot_min_delta_1,min(y_bot)-small_y_delta);
    y_delta_max = max(max(y_top)+small_y_delta,y_plot_max_delta_1);
    y_delta = [y_delta_min y_bot y_top y_delta_max];
end

